<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Skill extends Model 
{

    protected $table = 'skills';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('standard', 'spin', 'pop', 'front', 'rear', 'side', 'scrabble', 'drop', 'punt', 'grubber', 'goal');

    public function user()
    {
        return $this->belongsTo('\User');
    }

}